/*
 * Decompiled with CFR 0.152.
 */
package org.usb4java.javax.descriptors;

import javax.usb.UsbEndpointDescriptor;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.usb4java.DescriptorUtils;
import org.usb4java.EndpointDescriptor;
import org.usb4java.javax.descriptors.SimpleUsbDescriptor;

public final class SimpleUsbEndpointDescriptor
extends SimpleUsbDescriptor
implements UsbEndpointDescriptor {
    private static final long serialVersionUID = 1L;
    private final byte bInterval;
    private final short wMaxPacketSize;
    private final byte bmAttributes;
    private final byte bEndpointAddress;

    public SimpleUsbEndpointDescriptor(byte bLength, byte bDescriptorType, byte bEndpointAddress, byte bmAttributes, short wMaxPacketSize, byte bInterval) {
        super(bLength, bDescriptorType);
        this.bEndpointAddress = bEndpointAddress;
        this.wMaxPacketSize = wMaxPacketSize;
        this.bmAttributes = bmAttributes;
        this.bInterval = bInterval;
    }

    public SimpleUsbEndpointDescriptor(EndpointDescriptor descriptor) {
        this(descriptor.bLength(), descriptor.bDescriptorType(), descriptor.bEndpointAddress(), descriptor.bmAttributes(), descriptor.wMaxPacketSize(), descriptor.bInterval());
    }

    @Override
    public byte bEndpointAddress() {
        return this.bEndpointAddress;
    }

    @Override
    public byte bmAttributes() {
        return this.bmAttributes;
    }

    @Override
    public short wMaxPacketSize() {
        return this.wMaxPacketSize;
    }

    @Override
    public byte bInterval() {
        return this.bInterval;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.bDescriptorType()).append(this.bLength()).append(this.bEndpointAddress).append(this.bInterval).append(this.bmAttributes).append(this.wMaxPacketSize).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleUsbEndpointDescriptor other = (SimpleUsbEndpointDescriptor)obj;
        return new EqualsBuilder().append(this.bLength(), other.bLength()).append(this.bDescriptorType(), other.bDescriptorType()).append(this.bEndpointAddress, other.bEndpointAddress).append(this.bInterval, other.bInterval).append(this.bmAttributes, other.bmAttributes).append(this.wMaxPacketSize, other.wMaxPacketSize).isEquals();
    }

    public String toString() {
        return String.format("Endpoint Descriptor:%n  bLength %18d%n  bDescriptorType %10d%n  bEndpointAddress %9s  EP %d %s%n  bmAttributes %13d%n    Transfer Type             %s%n    Synch Type                %s%n    Usage Type                %s%n  wMaxPacketSize %11d%n  bInterval %16d%n", this.bLength() & 0xFF, this.bDescriptorType() & 0xFF, String.format("0x%02x", this.bEndpointAddress() & 0xFF), this.bEndpointAddress() & 0xF, DescriptorUtils.getDirectionName(this.bEndpointAddress()), this.bmAttributes() & 0xFF, DescriptorUtils.getTransferTypeName(this.bmAttributes()), DescriptorUtils.getSynchTypeName(this.bmAttributes()), DescriptorUtils.getUsageTypeName(this.bmAttributes()), this.wMaxPacketSize() & 0xFFFF, this.bInterval() & 0xFF);
    }
}

